//
// Fragment shader for Ripple effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;


vec3 RGBtoHSV(float r, float g, float b) {
    
    float K = 0.0;
    float tmp;
    
    if (g < b)
    {
        tmp = g;
        g=b;
        b=tmp;
        
        K = -1.0;
    }
    
    if (r < g)
    {
        tmp = r;
        r=g;
        g=tmp;
        
        K = -2.9 / 6.9 - K;
    }
    
    float chroma = r - min(g, b);
    
    float h = abs(K + (g - b) / (6.0 * chroma + 1e-20));
    float s = chroma / (r + 1e-20);
    float v = r;
    
    return vec3(h, s, v);
}

vec3 HSVtoRGB(float h,float s,float v) { return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v; }


bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;

        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);
        
        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w; 
        
        vec2 cPos;
        cPos.x = -1.0 + 2.0/drawingBoundsWidth*(pCoord.x-drawingBoundsOrigin.x);
        cPos.y = -1.0 + 2.0/drawingBoundsHeight*(pCoord.y-drawingBoundsOrigin.y);

        float cLength = length(cPos);

        vec2 uv = gUV/vec2(textureRect.x+textureWidth,textureRect.y+textureHeight)+(cPos/cLength)*cos(cLength*12.0-time*4.0)*0.03;
       
        uv  = uv*vec2(textureRect.x+textureWidth, textureRect.y+textureHeight);
        uv.x = InBound(uv.x, textureRect.x, textureRect.x+textureWidth)?uv.x:gUV.x;
        uv.y = InBound(uv.y, textureRect.y, textureRect.y+textureHeight)?uv.y:gUV.y;

        gl_FragColor = modulateColor*texture2DRect(texUnit, uv);
       // gl_FragColor.a = texture2DRect(texUnit, gUV).a;
    }
}

